document.getElementById('screeningForm').addEventListener('submit', async function (e) {
  e.preventDefault();

  const payload = {
    firstName: document.getElementById('firstName').value,
    lastName: document.getElementById('lastName').value,
    email: document.getElementById('email').value,
    dob: document.getElementById('dob').value,
    ssn: document.getElementById('ssn').value,
    driverLicense: {
      number: document.getElementById('dlNumber').value,
      state: document.getElementById('dlState').value,
    },
    packageCode: document.getElementById('packageCode').value
  };

  const mockResponse = {
    candidateId: 'cnd_' + Math.floor(Math.random() * 1000000),
    status: 'initiated',
    message: 'Candidate created and background check started'
  };

  document.getElementById('result').innerHTML = `
    <p><strong>Status:</strong> ${mockResponse.status}</p>
    <p><strong>Candidate ID:</strong> ${mockResponse.candidateId}</p>
    <p><strong>Message:</strong> ${mockResponse.message}</p>
  `;

  localStorage.setItem('lastCandidateId', mockResponse.candidateId);
});

function checkStatus() {
  const candidateId = document.getElementById('candidateId').value || localStorage.getItem('lastCandidateId');
  if (!candidateId) return alert('Please enter a candidate ID');

  const mockStatus = {
    candidateId: candidateId,
    status: 'in_progress',
    checks: {
      ssnTrace: 'completed',
      motorVehicleRecords: 'pending'
    }
  };

  document.getElementById('statusResult').innerHTML = `
    <p><strong>Candidate ID:</strong> ${mockStatus.candidateId}</p>
    <p><strong>Status:</strong> ${mockStatus.status}</p>
    <ul>
      <li>SSN Trace: ${mockStatus.checks.ssnTrace}</li>
      <li>MVR: ${mockStatus.checks.motorVehicleRecords}</li>
    </ul>
  `;
}
